/* Include config.h first so config macros are always defined consistently */
#include "config.h"

#include <cyg/hal/hal_arch.h>
#include <cyg/kernel/kapi.h>

#include <stdio.h>
#include <math.h>
#include <assert.h>

#include "ezs_counter.h"
#include "ezs_sensor.h"
#include "ezs_stopwatch.h"
#include "ezs_adc.h"
#include "ezs_dac.h"
#include "ezs_io.h"
#include "ezs_serial.h"
#include "ezs_fft.h"
#include "ezs_interpolation.h"
#include "ezs_plot.h"
#include "ezs_plot_pds.h"
#include "ezs_fb.h"
#include "ezs_lcd.h"

#ifdef SANITY_TEST
#include "ezs_test.h"
#endif

#define SERIAL_IRQ CYGNUM_HAL_INTERRUPT_UART1


// Buffers
static cyg_uint32 s_time_domain[TIME_DOMAIN_LENGTH];
static float s_frequency_domain[PDS_LENGTH];
static unsigned int s_position = 0;

static char s_serial_buffer[SERIAL_BUFFER_LENGTH];
static unsigned int s_serial_position;
static bool s_command_decodable = false;

// alarm counter handle
static cyg_handle_t real_time_counter;

/* ========================== FORWARD DECLARATIONS =========================== */

/* ============================ TYPE DEFINITIONS ============================= */
enum CommandStatus
{
	CommandComplete,
	CommandIncomplete
};

enum Command
{
	DisplayTime = (1 << 1),
	DisplayPDS  = (1 << 2),
	TriggerOn   = (1 << 3),
	TriggerOff  = (1 << 4),
	TLevelRise  = (1 << 5),
	TLevelFall  = (1 << 6),
	Invalid     = 0x00,
};

enum State
{
	ChangeMe =(1 << 1),
	/*
	 * TODO: Zustände ergaenzen
	 */
};


/* ========================== GLOBAL TASK VARIABLES ========================== */

static volatile uint8_t serial_input;
static cyg_flag_t s_command_flag;

// Thread 1 - Sampling of the Signal
static cyg_uint8    t1_sampling_stack[STACKSIZE];
static cyg_handle_t t1_sampling_thread_handle;
static cyg_thread   t1_sampling_thread_data;
static cyg_alarm	t1_sampling_alarm;
static cyg_handle_t t1_sampling_alarm_handle;

// Thread 2 - Procrastinator / Trigger
static cyg_uint8    t2_trigger_stack[STACKSIZE];
static cyg_handle_t t2_trigger_thread_handle;
static cyg_thread   t2_trigger_thread_data;
static cyg_alarm	t2_trigger_alarm;
static cyg_handle_t t2_trigger_alarm_handle;

// Thread 3 - Analysis
static cyg_uint8    t3_analysis_stack[STACKSIZE];
static cyg_handle_t t3_analysis_thread_handle;
static cyg_thread   t3_analysis_thread_data;
static cyg_alarm	t3_analysis_alarm;
static cyg_handle_t t3_analysis_alarm_handle;

// Thread 4 - Signal Visualization
static cyg_uint8    t4_time_domain_visualization_stack[STACKSIZE];
static cyg_handle_t t4_time_domain_visualization_thread_handle;
static cyg_thread   t4_time_domain_visualization_thread_data;
static cyg_alarm	t4_time_domain_visualization_alarm;
static cyg_handle_t t4_time_domain_visualization_alarm_handle;

// Thread 5 - PDS Visualization
static cyg_uint8    t5_pds_visualization_stack[STACKSIZE];
static cyg_handle_t t5_pds_visualization_thread_handle;
static cyg_thread   t5_pds_visualization_thread_data;
static cyg_alarm	t5_pds_visualization_alarm;
static cyg_handle_t t5_pds_visualization_alarm_handle;



/* ============================ UTILITY FUNCTIONS ============================ */

enum Command decode_command(void)
{

	enum Command ret = Invalid;
	/*
	 * TODO: Code ergaenzen
	 */

	return ret;
}


/* ============================= COMMAND PARSER ============================= */
static enum CommandStatus packet_receive(char c)
{
	assert(s_serial_position < SERIAL_BUFFER_LENGTH);
	/*
	 * TODO: Code ergaenzen
	 */

}
/* ============================== ISR HANDLERS =============================== */

cyg_uint32 serial_isr_handler(cyg_vector_t vector, cyg_addrword_t data)
{
	/*
	 * TODO: Code ergaenzen falls noetig
	 */
	if (ezs_serial_char_available())
	{
		/*
		 * TODO: Code ergaenzen
		 */
		ezs_serial_getc();
		cyg_interrupt_acknowledge(vector);
		return CYG_ISR_CALL_DSR;
	}
	else
	{
		return CYG_ISR_HANDLED;
	}

}


/* ============================== DSR HANDLERS =============================== */

void serial_dsr_handler(cyg_vector_t vec, cyg_ucount32 count, cyg_addrword_t data)
{
	/*
	 * TODO: Code ergaenzen
	 */
}



// Zustandsmaschine
// T8
static void t8_state_manager_task_entry(cyg_addrword_t data)
{
	while (1)
	{
		/*
		 * TODO: Code ergaenzen
		 */
	}
}

/* ========================== TASK ENTRY FUNCTIONS =========================== */
// T1
static void t1_sampling_task_entry(cyg_addrword_t data)
{
	while (1)
	{
		/*
		 * TODO: Code ergaenzen
		 */

		cyg_thread_suspend(cyg_thread_self());
	}
}

// T2
static void t2_trigger_task_entry(cyg_addrword_t data)
{
	while (1)
	{
		/*
		 * TODO: Code ergaenzen
		 */

		cyg_thread_suspend(cyg_thread_self());
	}
}

// T3
static void t3_analysis_task_entry(cyg_addrword_t data)
{
	while (1)
	{
		/*
		 * TODO: Code ergaenzen
		 */

		cyg_thread_suspend(cyg_thread_self());
	}
}


// T4
static void t4_time_domain_visualization_task_entry(cyg_addrword_t data)
{
	while (1)
	{
		/*
		 * TODO: Code ergaenzen
		 */


		cyg_thread_suspend(cyg_thread_self());
	}
}

// T5
static void t5_pds_visualization_task_entry(cyg_addrword_t data)
{
	while (1)
	{
		/*
		 * TODO: Code ergaenzen
		 */

		cyg_thread_suspend(cyg_thread_self());
	}
}


/* ============================= ALARM HANDLERS ============================== */


static void t1_sampling_alarmfn(cyg_handle_t alarmH, cyg_addrword_t data)
{
	cyg_thread_resume(t1_sampling_thread_handle);
}

static void t2_trigger_alarmfn(cyg_handle_t alarmH, cyg_addrword_t data)
{
	cyg_thread_resume(t2_trigger_thread_handle);
}

static void t3_analysis_alarmfn(cyg_handle_t alarmH, cyg_addrword_t data)
{
	cyg_thread_resume(t3_analysis_thread_handle);
}

static void t4_time_domain_visualization_alarmfn(cyg_handle_t alarmH, cyg_addrword_t data)
{
	cyg_thread_resume(t4_time_domain_visualization_thread_handle);
}

static void t5_pds_visualization_alarmfn(cyg_handle_t alarmH, cyg_addrword_t data)
{
	cyg_thread_resume(t5_pds_visualization_thread_handle);
}

static cyg_addrword_t data_dummy = 0;
static cyg_interrupt serial_intr;
static cyg_handle_t  serial_isr_handle;

/* ============================== SYSTEM ENTRY =============================== */
void cyg_user_start(void)
{
	ezs_counter_init();
	ezs_serial_init();
	ezs_lcd_init();
	ezs_fb_init();
	ezs_sensors_init();

#ifdef SANITY_TEST
	ezs_sanity_test();
#endif

	cyg_interrupt_create(SERIAL_IRQ,
			1,
			0,
			serial_isr_handler,
			serial_dsr_handler,
			&serial_isr_handle,
			&serial_intr) ;
	cyg_interrupt_attach(serial_isr_handle);
	cyg_interrupt_unmask(SERIAL_IRQ);

	// create tasks
	cyg_thread_create(SAMPLING_TASK_PRIORITY,
			  &t1_sampling_task_entry,
			  0,
			  "sampling task",
			  t1_sampling_stack,
			  STACKSIZE,
			  &t1_sampling_thread_handle,
			  &t1_sampling_thread_data);

	cyg_thread_create(TRIGGER_TASK_PRIORITY,
			  &t2_trigger_task_entry,
			  0,
			  "trigger task",
			  t2_trigger_stack,
			  STACKSIZE,
			  &t2_trigger_thread_handle,
			  &t2_trigger_thread_data);

	cyg_thread_create(ANALYSIS_TASK_PRIORITY,
			  &t3_analysis_task_entry,
			  0,
			  "analysis task",
			  t3_analysis_stack,
			  STACKSIZE,
			  &t3_analysis_thread_handle,
			  &t3_analysis_thread_data);

	cyg_thread_create(TIME_DOMAIN_VISUALIZATION_TASK_PRIORITY,
			  &t4_time_domain_visualization_task_entry,
			  0,
			  "time domain visualization task",
			  t4_time_domain_visualization_stack,
			  STACKSIZE,
			  &t4_time_domain_visualization_thread_handle,
			  &t4_time_domain_visualization_thread_data);

	cyg_thread_create(PDS_VISUALIZATION_TASK_PRIORITY,
			  &t5_pds_visualization_task_entry,
			  0,
			  "pds visualization task",
			  t5_pds_visualization_stack,
			  STACKSIZE,
			  &t5_pds_visualization_thread_handle,
			  &t5_pds_visualization_thread_data);

	// create and initialize alarms
	cyg_clock_to_counter(cyg_real_time_clock(), &real_time_counter);
	cyg_uint32 timebase = cyg_current_time() + 3;

	cyg_alarm_create(real_time_counter,
			 t1_sampling_alarmfn,
			 data_dummy,
			 &t1_sampling_alarm_handle,
			 &t1_sampling_alarm);
	cyg_alarm_initialize(t1_sampling_alarm_handle,
			     timebase + ms_to_cyg_ticks(SAMPLING_TASK_PHASE),
			     ms_to_cyg_ticks(SAMPLING_TASK_PERIOD));

	cyg_alarm_create(real_time_counter,
			 t2_trigger_alarmfn,
			 data_dummy,
			 &t2_trigger_alarm_handle,
			 &t2_trigger_alarm);
	cyg_alarm_initialize(t2_trigger_alarm_handle,
			     timebase + ms_to_cyg_ticks(TRIGGER_TASK_PHASE),
			     ms_to_cyg_ticks(TRIGGER_TASK_PERIOD));

	cyg_alarm_create(real_time_counter,
			 t3_analysis_alarmfn,
			 data_dummy,
			 &t3_analysis_alarm_handle,
			 &t3_analysis_alarm);
	cyg_alarm_initialize(t3_analysis_alarm_handle,
			     timebase + ms_to_cyg_ticks(ANALYSIS_TASK_PHASE),
			     ms_to_cyg_ticks(ANALYSIS_TASK_PERIOD));

	cyg_alarm_create(real_time_counter,
			 t4_time_domain_visualization_alarmfn,
			 data_dummy,
			 &t4_time_domain_visualization_alarm_handle,
			 &t4_time_domain_visualization_alarm);
	cyg_alarm_initialize(t4_time_domain_visualization_alarm_handle,
			     timebase + ms_to_cyg_ticks(TIME_DOMAIN_VISUALIZATION_TASK_PHASE),
			     ms_to_cyg_ticks(TIME_DOMAIN_VISUALIZATION_TASK_PERIOD));

	cyg_alarm_create(real_time_counter,
			 t5_pds_visualization_alarmfn,
			 data_dummy,
			 &t5_pds_visualization_alarm_handle,
			 &t5_pds_visualization_alarm);
	cyg_alarm_initialize(t5_pds_visualization_alarm_handle,
			     timebase + ms_to_cyg_ticks(PDS_VISUALIZATION_TASK_PHASE),
			     ms_to_cyg_ticks(PDS_VISUALIZATION_TASK_PERIOD));
}
