#include <stdint.h>
#include "ezs_io.h"
#include "ezs_stopwatch.h"
#include "ezs_test.h"

// Stringification in the C preprocessor: See https://gcc.gnu.org/onlinedocs/gcc-3.4.3/cpp/Stringification.html
#define xstr(s) str(s)
#define str(s) #s

#define EZS_TEST_ASSERT(cond, msg)                                     \
	{                                                                  \
		++ezs_tests_run;                                               \
		if (!(cond)) {                                                 \
			++ezs_failed_tests;                                        \
			ezs_printf("assert(%s) failed: %s\n", xstr(cond),  msg);   \
		}                                                              \
	} while (0);

void ezs_sanity_test(void) {
	uint32_t ezs_failed_tests = 0;
	uint32_t ezs_tests_run = 0;

	ezs_printf("TESTING: ms_to_cyg_ticks\n");
	EZS_TEST_ASSERT(ms_to_cyg_ticks(0llu) == 0llu, "ms_to_cyg_ticks conversion failed for 0 ms");
	EZS_TEST_ASSERT(ms_to_cyg_ticks(1llu) == 1llu, "ms_to_cyg_ticks conversion failed for 1 ms");
	EZS_TEST_ASSERT(ms_to_cyg_ticks(10llu) == 10llu, "ms_to_cyg_ticks conversion failed for 10 ms");
	EZS_TEST_ASSERT(ms_to_cyg_ticks(20llu) == 20llu, "ms_to_cyg_ticks conversion failed for 20 ms");
	EZS_TEST_ASSERT(ms_to_cyg_ticks(42llu) == 42llu, "ms_to_cyg_ticks conversion failed for 42 ms");
	EZS_TEST_ASSERT(ms_to_cyg_ticks(100llu) == 100llu, "ms_to_cyg_ticks conversion failed for 100 ms");
	EZS_TEST_ASSERT(ms_to_cyg_ticks(128llu) == 128llu, "ms_to_cyg_ticks conversion failed for 128 ms");
	EZS_TEST_ASSERT(ms_to_cyg_ticks(4096llu) == 4096llu, "ms_to_cyg_ticks conversion failed for 4096 ms");
	EZS_TEST_ASSERT(ms_to_cyg_ticks(4294967294llu) == 4294967294llu, "ms_to_cyg_ticks conversion failed for 4294967294 ms");
	EZS_TEST_ASSERT(ms_to_cyg_ticks(4294967295llu) == 4294967295llu, "ms_to_cyg_ticks conversion failed for 4294967295 ms");

	ezs_printf("TESTING: ms_to_ezs_ticks\n");
	EZS_TEST_ASSERT(ms_to_ezs_ticks(0llu) == 0llu, "ms_to_ezs_ticks conversion failed for 0 ms");
	EZS_TEST_ASSERT(ms_to_ezs_ticks(1llu) == 42000llu, "ms_to_ezs_ticks conversion failed for 1 ms");
	EZS_TEST_ASSERT(ms_to_ezs_ticks(10llu) == 420000llu, "ms_to_ezs_ticks conversion failed for 10 ms");
	EZS_TEST_ASSERT(ms_to_ezs_ticks(20llu) == 840000llu, "ms_to_ezs_ticks conversion failed for 20 ms");
	EZS_TEST_ASSERT(ms_to_ezs_ticks(42llu) == 1764000llu, "ms_to_ezs_ticks conversion failed for 42 ms");
	EZS_TEST_ASSERT(ms_to_ezs_ticks(100llu) == 4200000llu, "ms_to_ezs_ticks conversion failed for 100 ms");
	EZS_TEST_ASSERT(ms_to_ezs_ticks(128llu) == 5376000llu, "ms_to_ezs_ticks conversion failed for 128 ms");
	EZS_TEST_ASSERT(ms_to_ezs_ticks(4096llu) == 172032000llu, "ms_to_ezs_ticks conversion failed for 4096 ms");
	EZS_TEST_ASSERT(ms_to_ezs_ticks(102260llu) == 4294920000llu, "ms_to_ezs_ticks conversion failed for 102260 ms");
	EZS_TEST_ASSERT(ms_to_ezs_ticks(102261llu) == 4294962000llu, "ms_to_ezs_ticks conversion failed for 102261 ms");

	ezs_printf("Total: %llu tests, %llu successful, %llu failed\n"
	          , (long long unsigned) ezs_tests_run
	          , (long long unsigned)  ezs_tests_run - ezs_failed_tests
	          , (long long unsigned)  ezs_failed_tests);
	if (ezs_failed_tests == 0) {
		ezs_printf("ALL TESTS SUCCESSFUL, you might be fine\n");
	} else {
		ezs_printf("%llu TESTS FAILED. Please check your implementation of the tested utility functions\n", (long long unsigned) ezs_failed_tests);
	}
	ezs_test_status_lcd(ezs_failed_tests);
	while(1);
	return;
}
